/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.os.Build;
import android.support.v4.text.ICUCompatApi23;
import android.support.v4.text.ICUCompatIcs;
import java.util.Locale;

public final class ICUCompat {
    private static final ICUCompatImpl IMPL;

    public static String maximizeAndGetScript(Locale locale) {
        return IMPL.maximizeAndGetScript(locale);
    }

    private ICUCompat() {
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new ICUCompatImplLollipop() : (version >= 14 ? new ICUCompatImplIcs() : new ICUCompatImplBase());
    }

    static class ICUCompatImplLollipop
    implements ICUCompatImpl {
        ICUCompatImplLollipop() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return ICUCompatApi23.maximizeAndGetScript((Locale)locale);
        }
    }

    static class ICUCompatImplIcs
    implements ICUCompatImpl {
        ICUCompatImplIcs() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return ICUCompatIcs.maximizeAndGetScript((Locale)locale);
        }
    }

    static class ICUCompatImplBase
    implements ICUCompatImpl {
        ICUCompatImplBase() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return null;
        }
    }

    static interface ICUCompatImpl {
        public String maximizeAndGetScript(Locale var1);
    }
}

